//Average rate of return
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Concept Information
//ARR = (Average annual profits after taxes / Average Investment original investment) * 100
//Average investment = 1/2 (Total investment - scrap value)

//Given
projectA_investment = 500000       //in rupees
projectA_scrapvalue = 20000        //in rupees
profit_A = [40000,60000,70000,50000,20000]    //in rupees

//Solution
total_earnings = sum(profit_A)
N = length(profit_A)
average_earnings = total_earnings / N
average_investment = 1/2 * (projectA_investment - projectA_scrapvalue) + projectA_scrapvalue
average_rateofreturn = (average_earnings / average_investment) * 100

//Result
mprintf("\n  Total Earnings: %d rupees",total_earnings)
mprintf("\n  Average Earnings: %d rupees",average_earnings)
mprintf("\n  Average Investment: %d rupees",average_investment)
mprintf("\n  Average Rate of Return: %.2f percent",average_rateofreturn)

//Output
// 
//  Total Earnings: 240000 rupees
//  Average Earnings: 48000 rupees
//  Average Investment: 260000 rupees
//  Average Rate of Return: 18.46 percent
